-- simBoard.lua

addSearchResourcesPath( moduleDirectory .. "/configuration/" )
local baseC      = sasl.gl.loadImage("KeySet_gray10.png",   0, 222, 256,  34)
local Wheel      = sasl.gl.loadImage("KeySet_gray10.png", 224,   0,  32, 106)
local keyArrow   = sasl.gl.loadImage("KeySet_gray10.png",  75,   0,  72, 144)
local keyButton1 = sasl.gl.loadImage("KeySet_gray10.png", 150, 107, 103,  68)
local roboto2 = loadFont(getXPlanePath().."Resources/fonts/Roboto-Bold.ttf")
local noto2 = loadFont(getXPlanePath().."Resources/fonts/NotoSansCJK-SC-Regular.otf")

size = {1200, 34}

-- setting mouse action  ------------------------------------------------
function onMouseDown(component , x , y , button , parentX , parentY)
    if get(simStage) == 0 then
		if button == MB_LEFT then
			if x > 475 and x <= 495 then
				T = get(targetH)
				if y > 0 and y < 16 then
					if T <= 200 then
						T = 100
					else
						T = T - 200
					end
					set(targetH, T)                      -- TargetH Down
				elseif y > 17 and y < 30 then
					if T == 100 then
						T = 200
					else
						T = T + 200
						if T > 800 then T = 800 end
					end
					set(targetH, T)                      -- TargetH Up
				end
			elseif x > 5 and x <= 90 then
				if y > 2 and y < 30 then                 -- "Liftoff" pressed
					set(startIsOn, 1)
					set(resetIsOn, 0)
					print("Liftoff pressed") 
				end
			end
		end

	elseif get(simStage) ~= 0 then
		if button == MB_LEFT then
			if x > 5 and x <= 92 then
				if y > 2 and y < 30 then                 -- "Reset" pressed
					set(simStage, 0)
					set(startIsOn, 0)
					set(resetIsOn, 1)                    -- Reset ready state
					sasl.commandOnce( viewSet )
					sasl.stopTimer( simTime )
-- 					iniValSet()                          -- Initialize values
--					setRocket()                          -- Set rocket parameters
-- 					config = 0 
					print("Reset pressed") 
				end
			end
		end
	end
    return true
end

function onMouseWheel ( component, x, y, button, parentX, parentY, value)
    if get(simStage) == 0 then
		if x > 250 and x <= 318 then
			if y > 0 and y < 30 then
				P = get(headPsi) + value
				if P < 5 then
					P = 5
				elseif P > 175 then
					P = 175
				end
				set(headPsi, P)
			end
		end
	end
	return true
end
